﻿$(document).ready(function ()
{
    jQuery.extend(true, jQuery.fn.rate.settings.symbols, {
        fontawesome_starsss: { //example for adding built-in symbols
            base: '<i class="fa-regular fa-star"> </i>',
            hover: '<i class="fa-solid fa-star"> </i>',
            selected: '<i class="fa-solid fa-star"> </i>',
        },
    });

    const ratings = $('.rating'); 
    
    ratings.each(function ()
    {
        const elem = $(this);
        let glyphNameFull = elem.data('glyph-name-full');
        let glyphNameEmpty = elem.data('glyph-name-empty');
        let ratingType = elem.data('rating-type');
        let initialValue = elem.data('rating-value');
        let imgFull = elem.data('image-full');
        let imgEmpty = elem.data('image-empty');
        let displayType = elem.data('display-type');

        let width = elem.data('width');
        let spanSize;

        if (width !== undefined)
        {
            spanSize = ((width) / 5.625).toString(); //magic number
            //set size of a star
        }
        else
        {
            spanSize = "12";
        }

        let rateOptions = {
            max_value: 5,
            step_size: 1,
            readonly: ratingType === 'display',
            disablezero: true
        };

        if (initialValue !== undefined)
        {
            $.extend(rateOptions, {
                initial_value: parseFloat(initialValue)
            });
        }

        if (displayType === 'glyph')
        {
            $.extend(rateOptions, {
                selected_symbol_type: 'glyph',
                symbols: {
                    glyph: {
                        base: `<i class="${glyphNameEmpty}" style="font-size: ${spanSize}px;"></i>`,
                        hover: `<i class="${glyphNameFull}" style="font-size: ${spanSize}px;"></i>`,
                        selected: `<i class="${glyphNameFull}" style="font-size: ${spanSize}px;"></i>`,
                    }
                },
            });
        }

        if (displayType === 'image')
        {
            $.extend(rateOptions,
            {
                selected_symbol_type: 'image',
                symbols:
                {
                    image:
                    {
                        base: `<img src="${imgEmpty}" class="icon-empty">`,
                        hover: `<img src="${imgFull}" class="icon-full">`,
                        selected: `<img src="${imgFull}" class="icon-full">`,
                    }
                },
            });
        }

        elem.rate(rateOptions);
        adjustRatingDivSize();
    });

    ratings.on('change', function (event, data)
    {
        if (data.bypassreadonly)
        { //prevent cyclic calls
            return;
        }
        const elem = $(this);
        let entity = elem.data('entity');
        let ic = elem.data('ic');
        let u = elem.data('u');
        let requestUrl = QIPortalAPI.appPath + 'Rating.aspx'; //todo requesturl        

        $.ajax(
    {
            url: requestUrl,
            type: 'POST',
            data:
            {
                value: data.to,
                entity: entity,
                ic: ic,
                u: u
            },
            success: function (response)
            {
                updateRatingVisualNumber(ic, u, data.to);
                refreshRatingDisplay(ic, u, data.to);
            },
            error: function (xhr, status, error)
            {
                console.error('Error updating rating:', status, error);
            }
        });
    });

    function adjustRatingDivSize()
    {
        ratings.each(function ()
        {
            const ratingDiv = $(this);
            const spanElement = ratingDiv.find('.rate-base-layer span').first();

            let width = ratingDiv.data('width');
            let height = ratingDiv.data('height');

            if (width !== undefined)
            {
                ratingDiv.width(width);
            }

            if (height !== undefined)
            {
                ratingDiv.height(height);
                ratingDiv.find('.rate-base-layer, .rate-hover-layer, .rate-select-layer').each(function ()
                {
                    $(this).css('height', height + 'px');
                });
                return;
            }

            ratingDiv.find('.rate-base-layer, .rate-hover-layer, .rate-select-layer').each(function ()
            {
                $(this).css('height', 48 + 'px');
            });

            if (spanElement.length && ratingDiv.length)
            {
                const spanWidth = spanElement.width();
                const totalWidth = spanWidth * 5;
                if (totalWidth === 0)
                {
                    ratingDiv.width(68);
                    ratingDiv.height(48);
                }
                else
                {
                    ratingDiv.width(totalWidth);
                }
            }
        });
    }

    function updateRatingVisualNumber(ic, u, newRating)
    {
        $(".ratingVisualNumber").each(function ()
        {
            const elem = $(this);
            let entity = elem.data('entity');
            let currentIc = elem.data('ic');
            let currentU = elem.data('u');
            if (currentIc === ic && currentU === u)
            {
                getRating(entity, currentIc, currentU).then(response =>
                {
                    let lines = response.split("\n");
                    let actualRating = lines[0].trim();
                    elem.text(actualRating);
                }).catch(error =>
                {
                    console.error('Failed to update rating:', error);
                });
            }
        });

        $(".goodsRatingsCount").each(function ()
        {
            const elem = $(this);
            let entity = elem.data('entity');
            let currentIc = elem.data('ic');
            let currentU = elem.data('u');
            let currentRatingCountValue = ($(this).data('current-rating-count-value'));
            if (currentIc === ic && currentU === u)
            {
                getRatingsCount(entity, currentIc, currentU, currentRatingCountValue).then(response =>
                {
                    let lines = response.split("\n");
                    let actualRating = lines[0].trim();
                    elem.text(actualRating);
                }).catch(error =>
                {
                    console.error('Failed to update rating:', error);
                });
            }
        });
    }

    function refreshRatingDisplay(ic, u, newRating)
    {
        let promises = [];
        $(".rating").each(function ()
        {
            const elem = $(this);
            let entity = elem.data('entity');
            let currentIc = elem.data('ic');
            let currentU = elem.data('u');
            let ratingType = elem.attr('data-rating-type');

            if (ratingType === "display" && currentIc == ic && currentU == u)
            {
                const fetchPromise = getRating(entity, currentIc, currentU).then(fetchedRating =>
                {
                    return {element: elem, rating: fetchedRating};
                });
                promises.push(fetchPromise);
            }
        });
        Promise.all(promises).then(results =>
        {
            results.forEach(result =>
            {
                let lines = result.rating.split("\n");
                let actualRating = lines[0].trim();
                result.element.data("rating-value", actualRating);
                result.element.attr("data-rating-value", actualRating);

                let numericValue = parseFloat(actualRating);
                let newWidth = ratingToPercentage(numericValue);

                setTimeout(() =>
                {
                    result.element.rate("setValue", "" + actualRating, true);
                }, 10);
                result.element.hide().show(0);
                result.element.find('.rate-select-layer').css('width', newWidth);
            });
        }).catch(error =>
        {
            console.error('Failed to update ratings:', error);
        });
    }

    function ratingToPercentage(rating)
    {
        let percent = ((rating / 5) * 100).toFixed(0);
        return percent + '%';
    }

    function getRating(entity, ic, u)
    {
        const requestUrl = QIPortalAPI.appPath + 'Rating.aspx';

        return new Promise((resolve, reject) =>
        {
            $.ajax(
            {
                url: requestUrl,
                type: 'GET',
                data:
                {
                    entity: entity,
                    ic: ic,
                    u: u
                },
                success: function (response)
                {
                    resolve(response);
                },
                error: function (xhr, status, error)
                {
                    console.error('Error fetching rating:', status, error);
                    reject(status + ': ' + error);
                }
            });
        });
    }

    function getRatingsCount(entity, ic, u, value)
    {
        const requestUrl = QIPortalAPI.appPath + 'Rating.aspx';

        return new Promise((resolve, reject) =>
        {
            $.ajax(
            {
                url: requestUrl,
                type: 'GET',
                data:
                {
                    entity: entity + "_RatingsCount",
                    ic: ic,
                    u: u,
                    value: value
                },
                success: function (response)
                {
                    resolve(response);
                },
                error: function (xhr, status, error)
                {
                    console.error('Error fetching rating:', status, error);
                    reject(status + ': ' + error);
                }
            });
        });
    }
});
